<?php
//
//  Custom Child Theme Functions
//
// I've included a "commented out" sample function below that'll add a home link to your menu
// More ideas can be found on "A Guide To Customizing The Thematic Theme Framework" 
// http://themeshaper.com/thematic-for-wordpress/guide-customizing-thematic-theme-framework/
// Adds a home link to your menu
// http://codex.wordpress.org/Template_Tags/wp_page_menu
//function childtheme_menu_args($args) {
//    $args = array(
//        'show_home' => 'Home',
//        'sort_column' => 'menu_order',
//        'menu_class' => 'menu',
//        'echo' => true
//    );
//	return $args;
//}
//add_filter('wp_page_menu_args','childtheme_menu_args');
define('THEMATIC_COMPATIBLE_BODY_CLASS', true);
define('THEMATIC_COMPATIBLE_POST_CLASS', true);
define('THEMATIC_COMPATIBLE_COMMENT_FORM', true);
define('THEMATIC_COMPATIBLE_FEEDLINKS', true);

function childtheme_create_stylesheet() {
    $templatedir = get_bloginfo('template_directory');
    $stylesheetdir = get_bloginfo('stylesheet_directory');
    ?>

    <?php
}

add_filter('thematic_create_stylesheet', 'childtheme_create_stylesheet');

// Remove the default Thematic Access
function remove_thematic_actions() {
    remove_action('thematic_header', 'thematic_brandingopen', 1);
    remove_action('thematic_header', 'thematic_blogtitle', 3);
    remove_action('thematic_header', 'thematic_blogdescription', 5);
    remove_action('thematic_header', 'thematic_access', 9);
    remove_action('thematic_header', 'thematic_brandingclose', 7);
}

add_action('init', 'remove_thematic_actions');

//suppr scripts dans header
function childtheme_head_scripts() {
    ?>
    <script type="text/javascript">
        var appUrl = 'http://www.tutorom.fr';
        var themeUrl = 'http://www.tutorom.fr/themes/default';
        var arrowImg='http://www.tutorom.fr/themes/default/images/menuArrow.gif';
    </script>
    <script type="text/javascript">
        var _gaq = _gaq || [];
        _gaq.push(['_setAccount', 'UA-3361497-1']);
        _gaq.push(['_trackPageview']);
    </script>
    <?php
}

add_filter('thematic_head_scripts', 'childtheme_head_scripts');

//modif header
function childtheme_header() {
    ?>
    <script src="http://www.tutorom.fr/app/scripts/dropdown.class.js" language="javascript" type="text/javascript"></script>
    <script type="text/javascript">
        jQuery(document).ready(function() {
            /*Script top menu*/
            jQuery("ul.subnav").parent().append("<span></span>");
            jQuery("ul.topnav li").mouseover(function() {
                                                    
                jQuery(this).find("ul.subnav").show(); 
                jQuery(this).hover(function() {
                }, function(){	
                    jQuery(this).find("ul.subnav").hide(); 
                });
            });
            jQuery("ul.topnav li").mouseout(function() { 
                jQuery(this).addClass("subhover"); 
                jQuery(this).removeClass("subhover"); 
            });
            jQuery("ul.subnav a").click(function(){
                jQuery(this).parent().parent(".subnav").hide();
            });
            jQuery("ul#jDropDown").jDropDown({});
            jQuery("input#modSearchTitleWord").focus(function() {
                var val = jQuery(this).val();
                if (val == "Que voulez-vous apprendre ?"){
                    jQuery(this).val("");
                }
            });
            jQuery("input#modSearchTitleWord").blur(function() {
                var val = jQuery(this).val();
                if (val == ""){
                    jQuery(this).val("Que voulez-vous apprendre ?");
                }
            });
        });
    </script>
    <div id="header">
        <div id="header-l">
            <div id="header-r">
                <div id="topleft">
                    <h1 id="logo">
                        <a href="http://www.tutorom.fr">
                            <span>Tutorom - Formation vidéo aux logiciels et aux languages Informatiques</span>
                        </a>
                    </h1>
                    <h2 id="signature">
                        <a href="http://www.tutorom.fr">
                            <span>une mÃ©thode d'apprentissage ultra-performante.</span>
                            <span> Des tutoriels vidéos qui vous guident pas Ã  pas.</span>
                            <span>Choix du support : VOD, téléchargement et CD/DVD.</span>
                        </a>
                    </h2>
                </div>
                <div id="topright">
                    <ul class="topnav">
                        <li>
                            <a href="#">Nos solutions</a>
                            <ul class="subnav">
                                <p style="margin: 0">
                                    <strong>Particuliers</strong>
                                </p>
                                <dd><a href="http://www.tutorom.fr/formation-video">Tutoriels Vidéos</a></dd>
                                <dd><a href="http://www.tutorom.fr/formation-accompagnee">Formation en Tête à  Tête</a></dd>
                                <p>
                                    <strong>Professionnels</strong>
                                </p>
                                <dd><a href="http://www.tutorom.fr/multi-utilisateur">Compte Multi-Utilisateurs</a></dd>
                                <dd><a href="http://www.tutorom.fr/parcours-foad">Parcours FOAD</a></dd>
                            </ul>
                        </li>
                        <li>
                            <a href="#">Lecteur &amp; Apps</a>
                            <ul class="subnav">
                                <li><a href="http://www.tutorom.fr/lecteur-tutorom">Lecteur Tutorom</a></li>
                                <!--<li><a href="http://www.tutorom.fr/lecteur-vtc">Lecteur VTC</a></li>-->
                                <li><a href="http://www.tutorom.fr/ipad">Application iPad</a></li>
                            </ul>
                        </li>
                        <li id="no-hover">
                            <a target="_blank" href="http://vod.tutorom.fr" title="AccÃ©der aux tutoriels en ligne (VOD)">Accès Formations<img alt="" src="http://www.tutorom.fr/themes/default/images/images-2013/external-link.gif"></a>
                            <!--<ul class="subnav">
                                    <li><a class="externe" href="http://vod.tutorom.fr" target="_blank">AccÃ¨s aux VidÃ©os en FranÃ§ais</a></li>
                                    <li><a class="externe" href="http://www.vtc.com" target="_blank">AccÃ¨s Plate-Forme VTC</a></li>
                            </ul>-->
                        </li>
                        <li>
                            <a href="#">Aide</a>
                            <ul class="subnav">
                                <li><a href="http://www.tutorom.fr/support-technique">Support Technique</a></li>
                                <li><a href="http://www.tutorom.fr/faq">FAQ</a></li>
                                <li><a target="_blank" href="http://www.tutorom.fr/LecteursVTC/guide/guide.htm">Guide du Lecteur Tutorom</a></li>
                                <li><a href="http://www.tutorom.fr/blog">Le Blog</a></li>
                                <li><a href="http://www.tutorom.fr/contactez-nous">Nous Contacter</a></li>
                            </ul>
                        </li>
                    </ul>
                    <div class="connexion">
                        <ul id="pannierItems">
                            <li class="connexionItem">
                                <a href="http://www.tutorom.fr/mon-compte" id="connexion">
                                    Connexion        
                                </a>
                            </li>
                            <li class="monPanier">
                                <a href="http://www.tutorom.fr/mon-panier" id="pannier"> Mon Pannier </a>
                            </li>
                        </ul>                                
                    </div>
                </div>
            </div>
        </div>
        <!-- Begin Navigation -->

        <div id="navigation"> 
            <div id="mainmenu">
                <div id="menu">
                    <div id="menuItems">
                        <ul class="blue" id="jDropDown">
                            <li class="firstItem"><a href="http://www.tutorom.fr/formation-vod">S'abonner</a></li>
                            <li>
                                <a href="http://www.tutorom.fr/categories-de-tutoriels/fr/">Nos Formations</a>
                                <div style="margin-left: -70px;" class="column_4">
                                    <ul class="categories">
                                        <li>
                                            <a href="http://www.tutorom.fr/categories-de-tutoriels/fr/animation">
                                                Animation &amp; 3D                                </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/categories-de-tutoriels/fr/audio">
                                                Audio                                </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/categories-de-tutoriels/fr/bdd">
                                                Bases de données                                </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/categories-de-tutoriels/fr/bureautique">
                                                Bureautique                                </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/categories-de-tutoriels/fr/graphisme">
                                                Graphisme                                </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/categories-de-tutoriels/fr/internet">
                                                Internet &amp; Web Design                                </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/categories-de-tutoriels/fr/loisirs">
                                                Loisirs Numériques                                </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/categories-de-tutoriels/fr/multimedia">
                                                Multimedia &amp; Video                                </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/categories-de-tutoriels/fr/photo">
                                                Photographie                                </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/categories-de-tutoriels/fr/programmation">
                                                Programmation                                </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/categories-de-tutoriels/fr/systemes">
                                                Systèmes                                </a> 
                                        </li>
                                    </ul>
                                    <div style="clear: both" class="clearer"><!-- --></div>
                                    <div class="main-nav-dd-lower">
                                        <a href="http://www.tutorom.fr/categories-de-tutoriels/fr/" class="btn_menu"> Toutes les Formations</a>
                                        <a href="http://www.tutorom.fr/categories-de-tutoriels/fr/quickstart" class="btn_menu"> Les Savoir-Faire</a>
                                        <a href="http://www.tutorom.fr/categories-de-tutoriels/fr/collections" class="btn_menu"> Les Coffrets Tutorom</a>
                                    </div>
                                    <div style="clear: both" class="clearer"><!-- --></div>
                                    <div class="menu-bottom">
                                        <div class="nouveautees">
                                            <div class="block">
                                                <a class="nouveauteesItem" href="http://www.tutorom.fr/tutoriel-video/adobe-photoshop-cs6-corrigez-optimisez-vos-prises-vues.htm">
                                                    <img width="70" src="http://www.tutorom.fr/themes/default/images/iPad/boitiers/boitier90x125/34413_boitier_90x125.jpg" alt="Tutoriel Adobe Photoshop CS6 : Corrigez et optimisez vos prises de vues">
                                                    <p>Tutoriel Adobe Photoshop CS6 : Corrigez et optimisez vos prises de vues</p>
                                                    <p class="accroche">
                                                    Rendez vos photos plus attrayantes avec les bons outils !                                        
                                                    </p>
                                                </a>
                                            </div>
                                            <div class="block">
                                                <a class="nouveauteesItem" href="http://www.tutorom.fr/tutoriel-video/apple-final-cut-pro-x-motion5.htm">
                                                    <img width="70" src="http://www.tutorom.fr/themes/default/images/iPad/boitiers/boitier90x125/34408_boitier_90x125.jpg" alt="Tutoriel Apple Final Cut Pro X : Motion 5">
                                                    <p>
                                                        Tutoriel Apple Final Cut Pro X : Motion 5                                        </p>
                                                    <p class="accroche">
                                                        Animez vos projets, titres et transitions avec des effets spectaculaires !                                        </p>
                                                </a>
                                            </div>
                                            <div style="clear: both" class="clearer"><!-- --></div>
                                            <div style="clear: both" class="clearer"><!-- --></div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li><a href="http://www.tutorom.fr/categories-de-tutoriels/fr/" class="">Logiciels</a>
                                <div style="margin-left: -153px; visibility: hidden;" class="column_4">
                                    <ul class="categories">
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/3ds" style="line-height: 15px;" class="">
                                                3ds Max                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/access" style="line-height: 15px;" class="">
                                                Access                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/acrobat" style="line-height: 15px;" class="">
                                                Acrobat                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/after+effects" style="line-height: 15px;" class="">
                                                After Effects                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/aperture" style="line-height: 15px;" class="">
                                                Aperture                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/bento" style="line-height: 15px;" class="">
                                                Bento                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/nikon+capture" style="line-height: 15px;" class="">
                                                Capture NX                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/compressor" style="line-height: 15px;" class="">
                                                Compressor                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/dreamweaver" style="line-height: 15px;" class="">
                                                Dreamweaver                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/excel" style="line-height: 15px;" class="">
                                                Excel                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/filemaker" style="line-height: 15px;" class="">
                                                FileMaker                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/final+cut" style="line-height: 15px;" class="">
                                                Final Cut Pro                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/flash" style="line-height: 15px;" class="">
                                                Flash                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/gimp" style="line-height: 15px;" class="">
                                                Gimp                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/google+apps" style="line-height: 15px;" class="">
                                                Google Apps                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/guitar+pro" style="line-height: 15px;" class="">
                                                Guitar Pro                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/ilife" style="line-height: 15px;" class="">
                                                iLife                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/illustrator" style="line-height: 15px;" class="">
                                                Illustrator                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/imovie" style="line-height: 15px;" class="">
                                                iMovie                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/indesign" style="line-height: 15px;" class="">
                                                InDesign                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/iphoto" style="line-height: 15px;" class="">
                                                iPhoto                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/iwork" style="line-height: 15px;" class="">
                                                iWork                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/apple+keynote" style="line-height: 15px;" class="">
                                                Keynote                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/lightroom" style="line-height: 15px;" class="">
                                                Lightroom                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/ableton+live" style="line-height: 15px;" class="">
                                                Live                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/mac+os+x" style="line-height: 15px;" class="">
                                                Mac OS X                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/motion" style="line-height: 15px;" class="">
                                                Motion                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/apple+numbers" style="line-height: 15px;" class="">
                                                Numbers                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/microsoft+outlook" style="line-height: 15px;" class="">
                                                Outlook                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/apple+pages" style="line-height: 15px;" class="">
                                                Pages                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/photoshop" style="line-height: 15px;" class="">
                                                Photoshop                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/photoshop+elements" style="line-height: 15px;" class="">
                                                Photoshop Elements                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/google+picasa" style="line-height: 15px;" class="">
                                                Picasa                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/microsoft+powerpoint" style="line-height: 15px;" class="">
                                                PowerPoint                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/premiere" style="line-height: 15px;" class="">
                                                Premiere                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/pro+tools" style="line-height: 15px;" class="">
                                                Pro Tools                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/quarkxpress" style="line-height: 15px;" class="">
                                                Quark XPress                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/vegas" style="line-height: 15px;" class="">
                                                Vegas Pro                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/microsoft+windows" style="line-height: 15px;" class="">
                                                Windows                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/microsoft+word" style="line-height: 15px;" class="">
                                                Word                                    </a> 
                                        </li>
                                        <li>
                                            <a href="http://www.tutorom.fr/rechercher-un-tutoriel/wordpress" style="line-height: 15px;" class="">
                                                Wordpress                                    </a> 
                                        </li>
                                    </ul>
                                    <div style="clear: both;" class="clearer"></div>
                                    <div class="nouveautees">
                                        <a href="http://www.tutorom.fr/rechercher-un-tutoriel/ableton" style="margin-left: 20px; margin-top: 10px;" class="">
                                            <img src="http://www.tutorom.fr/themes/default/images/images-2013/editeurs/ableton.png" alt="" style="float: left; margin-right: 14px; margin-top: 10px;margin-bottom:5px">
                                        </a>

                                        <a href="http://www.tutorom.fr/rechercher-un-tutoriel/adobe" style="margin-left: 20px; margin-top: 10px;" class="">
                                            <img src="http://www.tutorom.fr/themes/default/images/images-2013/editeurs/adobe.png" alt="" style="float: left; margin-right: 14px; margin-top: 10px;margin-bottom:5px">
                                        </a>

                                        <a href="http://www.tutorom.fr/rechercher-un-tutoriel/apple" style="margin-left: 20px; margin-top: 10px;" class="">
                                            <img src="http://www.tutorom.fr/themes/default/images/images-2013/editeurs/apple.png" alt="" style="float: left; margin-right: 14px; margin-top: 10px;margin-bottom:5px">
                                        </a>

                                        <a href="http://www.tutorom.fr/rechercher-un-tutoriel/arobas" style="margin-left: 20px; margin-top: 10px;" class="">
                                            <img src="http://www.tutorom.fr/themes/default/images/images-2013/editeurs/arobas.png" alt="" style="float: left; margin-right: 14px; margin-top: 10px;margin-bottom:5px">
                                        </a>

                                        <a href="http://www.tutorom.fr/rechercher-un-tutoriel/avid" style="margin-left: 20px; margin-top: 10px;" class="">
                                            <img src="http://www.tutorom.fr/themes/default/images/images-2013/editeurs/avid.png" alt="" style="float: left; margin-right: 14px; margin-top: 10px;margin-bottom:5px">
                                        </a>

                                        <a href="http://www.tutorom.fr/rechercher-un-tutoriel/dxo" style="margin-left: 20px; margin-top: 10px;" class="">
                                            <img src="http://www.tutorom.fr/themes/default/images/images-2013/editeurs/dxo.png" alt="" style="float: left; margin-right: 14px; margin-top: 10px;margin-bottom:5px">
                                        </a>

                                        <a href="http://www.tutorom.fr/rechercher-un-tutoriel/filemaker" style="margin-left: 20px; margin-top: 10px;" class="">
                                            <img src="http://www.tutorom.fr/themes/default/images/images-2013/editeurs/filemaker.png" alt="" style="float: left; margin-right: 14px; margin-top: 10px;margin-bottom:5px">
                                        </a>

                                        <a href="http://www.tutorom.fr/rechercher-un-tutoriel/google" style="margin-left: 20px; margin-top: 10px;" class="">
                                            <img src="http://www.tutorom.fr/themes/default/images/images-2013/editeurs/google.png" alt="" style="float: left; margin-right: 14px; margin-top: 10px;margin-bottom:5px">
                                        </a>

                                        <a href="http://www.tutorom.fr/rechercher-un-tutoriel/maxon" style="margin-left: 20px; margin-top: 10px;" class="">
                                            <img src="http://www.tutorom.fr/themes/default/images/images-2013/editeurs/maxon.png" alt="" style="float: left; margin-right: 14px; margin-top: 10px;margin-bottom:5px">
                                        </a>

                                        <a href="http://www.tutorom.fr/rechercher-un-tutoriel/microsoft" style="margin-left: 20px; margin-top: 10px;" class="">
                                            <img src="http://www.tutorom.fr/themes/default/images/images-2013/editeurs/microsoft.png" alt="" style="float: left; margin-right: 14px; margin-top: 10px;margin-bottom:5px">
                                        </a>

                                        <a href="http://www.tutorom.fr/rechercher-un-tutoriel/nikon" style="margin-left: 20px; margin-top: 10px;" class="">
                                            <img src="http://www.tutorom.fr/themes/default/images/images-2013/editeurs/nikon.png" alt="" style="float: left; margin-right: 14px; margin-top: 10px;margin-bottom:5px">
                                        </a>

                                        <a href="http://www.tutorom.fr/rechercher-un-tutoriel/sony" style="margin-left: 20px; margin-top: 10px;" class="">
                                            <img src="http://www.tutorom.fr/themes/default/images/images-2013/editeurs/sony.png" alt="" style="float: left; margin-right: 14px; margin-top: 10px;margin-bottom:5px">
                                        </a>
                                    </div>
                                    <div style="clear: both" class="clearer"></div>
                                </div>
                            </li>
                            <li>
                                <a href="http://www.tutorom.fr/auteurs" class="">Formateurs</a>
                                <div style="margin-left: -173px; visibility: hidden;" class="column_4">
                                    <ul class="categories">
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/419" class="">
                                                Cyril Todeschini                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/396" class="">
                                                Loic Lequesne                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/395" class="">
                                                Damien Guillaume                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/385" class="">
                                                Christophe Lizot                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/399" class="">
                                                Frédéric Flohr                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/369" class="">
                                                Jean Pierre Maffre                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/370" class="">
                                                Rachel Thiebaud                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/335" class="">
                                                Stéphanie Guillaume                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/282" class="">
                                                Franck Chopinet                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/210" class="">
                                                Gérard Trilles                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/221" class="">
                                                Jean Philippe Vaisse                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/204" class="">
                                                Yves Chauvel                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/207" class="">
                                                Gilles Février                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/42" class="">
                                                Ben Waldie                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/233" class="">
                                                Pierre Emmanuel Richet                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/239" class="">
                                                Marina Pavanello                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/240" class="">
                                                Pierre Brandeis                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/241" class="">
                                                Christian Meneux                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/238" class="">
                                                Steve Holzner                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/305" class="">
                                                Thierry Buanic                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/318" class="">
                                                David Julot                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/321" class="">
                                                Ba Dang                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/328" class="">
                                                Philippe Chaudré                                   </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/337" class="">
                                                Fouad Housni                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/340" class="">
                                                Yves Mariel                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/355" class="">
                                                Stéphanie Guillaume - Hervé Cafournet                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/356" class="">
                                                Arthur Griffith - Transcription : Corinne Badou                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/344" class="">
                                                James Street                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/364" class="">
                                                Anis Metz Kouddane                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/366" class="">
                                                Karl Khan                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/384" class="">
                                                Fabrice Colinet                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/402" class="">
                                                Alice CHERBONNEL                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/391" class="">
                                                Julien Chirouze                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/416" class="">
                                                Nicolas Lepretre                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/374" class="">
                                                John Fontana                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/342" class="">
                                                Trevor James                                    </a> 
                                        </li>
                                        <li>
                                            <a style="line-height: 15px;" href="http://www.tutorom.fr/authors-formation/414" class="">
                                                Florence Labord                                    </a> 
                                        </li>
                                    </ul>
                                    <div style="clear: both" class="clearer"><!-- --></div>
                                    <div class="main-nav-dd-lower">
                                        <a href="http://www.tutorom.fr/devenir-auteur" class="btn_menu"> Devenir Auteur</a>
                                        <a href="http://www.tutorom.fr/formation-accompagnee" class="btn_menu"> En Tête à  Tête avec un Formateur </a>
                                    </div>
                                    <div style="clear: both" class="clearer"><!-- --></div>
                                    <div style="clear: both" class="clearer"><!-- --></div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>                 
            </div>

            <div id="header-search">
                <form action="http://www.tutorom.fr/rechercher-mon-tutoriel/1" method="post" name="AjaxSearch">	
                    <input type="text" value="Que voulez-vous apprendre ?" name="searchKey" id="modSearchTitleWord">
                    <input type="image" alt="Lancer la recherche" class="search" src="http://www.tutorom.fr/themes/default/images/images-2013/loupe.png" style="padding: 0px; margin-top: -3px;">
                </form>
            </div>
        </div>
        <!-- End Navigation -->
    </div>
    <?php
}

add_filter('thematic_header', 'childtheme_header');

function childtheme_after() {
    ?>
    <script type="text/javascript">  (function() {
        var ga = document.createElement('script');     ga.type = 'text/javascript'; ga.async = true;
        ga.src = ('https:'   == document.location.protocol ? 'https://ssl'   : 'http://www') + '.google-analytics.com/ga.js';
        var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
    })();
    </script>

    <?php
}

add_filter('thematic_after', 'childtheme_after');

function childtheme_belowheader() {
    ?>
                                                <!--<p id="leBlog">Le Blog</p>-->
    <?php
}

add_filter('thematic_belowheader', 'childtheme_belowheader');

function pc_custom_footer() {
    ?>
    <div id="footer1">
        <div id="foot_in">

            <div class="f_li_W fw">
                <h3>TOP Recherches</h3>
                <ul class="f_li li_1">
                    <li><a href="http://www.tutorom.fr/photoshop-elements-10.htm">Photoshop elements 10</a></li>
                    <li><a href="http://www.tutorom.fr/photoshop-elements-9.htm">Photoshop elements 9</a></li>
                    <li><a href="http://www.tutorom.fr/photoshop-cs5.htm">Photoshop CS5</a></li> 
                    <li><a href="http://www.tutorom.fr/lightroom-3.htm">Photoshop Lightroom 3 </a></li>
                    <li><a href="http://www.tutorom.fr/capture-nx-2.htm">Capture NX 2 </a></li>
                </ul>
                <ul class="f_li li_2">
                    <li><a href="http://www.tutorom.fr/iphoto.htm">iPhoto ’11 </a></li>
                    <li><a href="http://www.tutorom.fr/dxo-6.htm">DxO Optics Pro 6</a></li>
                    <li><a href="http://www.tutorom.fr/Aperture-3.htm">Aperture 3</a></li>
                </ul> 
            </div>

            <div class="f_nc fw">
                <h3>Nous connaître</h3>
                <ul class="f_li">
                    <li><a href="http://www.tutorom.fr/a-propos">Logivaro</a></li>
                    <li><a href="http://www.tutorom.fr/vtc">VTC</a></li> 
                    <li><a href="http://www.tutorom.fr/auteurs">Les Auteurs</a></li>
                    <li><a href="http://www.tutorom.fr/devenir-auteur">Devenir Auteur</a></li>
                    <li><a href="http://www.tutorom.fr/affilielogin">Affiliation</a></li>
                </ul>
            </div>

            <div class="fw">
                <h3>Support</h3>
                <ul class="f_li">
                    <li><a href="http://www.tutorom.fr/contactez-nous" class="noborder">Contact</a></li> 
                    <li><a href="http://www.tutorom.fr/faq">FAQ</a></li>
                    <li><a href="http://www.tutorom.fr/support-technique">Support Technique</a></li>
                    <li><a href="http://www.tutorom.fr/guide-lecteur-tutorom">Guide Lecteur</a></li>    


                    <li><a target="_blank" href="http://www.tutorom.fr/repository/CGV/CGV-Logivaro.pdf">CGV</a></li>
                </ul>
            </div>
            <div class="fw">
                <h3>Produits</h3>
                <ul class="f_li">
                    <li><a href="http://www.tutorom.fr/formation-vod" class="noborder">Formation en ligne</a></li>
                    <li><a href="http://www.tutorom.fr/formation-elearning">Formation accompagnée</a></li>    
                    <li><a href="http://www.tutorom.fr/categories-de-tutoriels/fr/">Tutoriels vidéo</a></li>
                    <li><a href="http://www.tutorom.fr/multi-utilisateur">Compte Multi-utilisateurs</a></li>
                    <li><a href="http://www.tutorom.fr/abonnement-vtc">Cartes d'accès VTC</a></li>    



                </ul>
            </div>
            <div class="fw f_prod">
                <h3>Vente en magasin</h3>

                <img src="http://www.tutorom.fr/themes/default/images/images-2013/logos-magasins.png" alt="FNAC et Librairies Eyrolles" style="padding-top:1em">



            </div>

            <!----------------------------->
            <div class="homeblocks" id="bottom">
                <div id="findTuto">
                    <h3><span>Trouver une formation</span></h3>
                    <div class="findTuto1">
                        <h4>Principaux éditeurs</h4>
                        <ul>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/ableton">Ableton</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/adobe">Adobe</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/apple">Apple</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/arobas">Arobas</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/autodesk">AutoDesk</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/avid">Avid</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/dxo">DxO</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/filemaker">FileMaker</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/google">Google</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/maxon">Maxon</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/microsoft">Microsoft</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/nikon">Nikon</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/quark">Quark</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/sony">Sony</a></li>
                        </ul>
                        <h4 style="margin-top:1em">Langages de programation</h4>
                        <ul>
                            <li class="flag_fr">
                                <ul><li>
                                        <a href="http://www.tutorom.fr/tutoriel-video/java6trans_fr.htm">Java 6</a></li>
                                    <li><a href="http://www.tutorom.fr/tutoriel-video/php-mysql-fondamentaux.htm">Php &amp; Mysql</a></li>
                                </ul>
                            </li>
                            <li class="flag_en">
                                <ul><li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/mysql">MySql</a> </li>
                                    <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/php">Php</a></li>
                                    <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/asp">Asp.Net</a></li>
                                    <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/python">Python</a></li>
                                    <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/perl">Perl</a></li>
                                    <li><a href="http://www.tutorom.fr/tutoriel-video/Microsoft-Visual-Csharp.NET-tutorials.htm">C#</a> </li>
                                    <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/J2EE">J2EE</a></li>
                                    <li><a href="http://www.tutorom.fr/tutoriel-video/Objective-C-and-Xcode-Essential-Training-Tutorials.htm">Objective-C</a></li>
                                    <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/flex">Flex</a></li>
                                    <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/realbasic">Real Basic</a></li>
                                    <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/visual+basic">Visual Basic</a></li>
                                </ul>
                            </li>
                        </ul>

                    </div> <!-- end findTuto1 -->
                    <div class="findTuto2">
                        <h4>Rechercher par logiciel</h4>
                        <ul>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/3ds">3ds Max</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/access">Access</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/acrobat">Acrobat</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/after+effects">After Effects</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/aperture">Aperture</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/bento">Bento</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/nikon+capture">Capture NX</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/compressor">Compressor</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/dreamweaver">Dreamweaver</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/excel">Excel</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/filemaker">FileMaker</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/final+cut">Final Cut Pro</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/flash">Flash</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/gimp">Gimp</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/google+apps">Google Apps</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/guitar+pro">Guitar Pro</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/ilife">iLife</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/illustrator">Illustrator</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/imovie">iMovie</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/indesign">InDesign</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/iphoto">iPhoto</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/iwork">iWork</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/apple+keynote">Keynote</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/lightroom">Lightroom</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/ableton+live">Live</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/mac+os+x">Mac OS X</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/motion">Motion</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/apple+numbers">Numbers</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/microsoft+outlook">Outlook</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/apple+pages">Pages</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/photoshop">Photoshop</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/photoshop+elements">Photoshop Elements</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/google+picasa">Picasa</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/microsoft+powerpoint">PowerPoint</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/premiere">Premiere</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/pro+tools">Pro Tools</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/quarkxpress">Quark XPress</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/vegas">Vegas Pro</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/microsoft+windows">Windows</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/microsoft+word">Word</a></li>
                            <li><a href="http://www.tutorom.fr/rechercher-un-tutoriel/wordpress">Wordpress</a></li>
                        </ul>
                    </div> <!-- end findTuto2 -->
                </div> <!-- end findTuto -->

                <div id="latestBlog">
                    <h3><span>Nos actualités</span></h3>
                    <h4>Sur le blog...</h4>
                    <ul style="line-height:120%;margin-top:0">

                        <li style="margin:0"><a href="http://www.tutorom.fr/blog/2013/01/18/soldes-de-janvier-2013-cest-partit/">Soldes de Janvier 2013 : c?est parti !</a></li><li style="margin:0"><a href="http://www.tutorom.fr/blog/2013/01/15/nouveau-lecteur-tutorom-2013-plus-rapide-plus-connecte/">Nouveau lecteur Tutorom 2013 : plus rapide, plus connecté !</a></li><li style="margin:0"><a href="http://www.tutorom.fr/blog/2013/01/06/la-formation-windows-8-indispensable/">La formation Windows 8 indispensable !</a></li><li style="margin:0"><a href="http://www.tutorom.fr/blog/2013/01/04/mountain-lion-et-le-lecteur-vtc/">Mountain Lion et le lecteur VTC</a></li><li style="margin:0"><a href="http://www.tutorom.fr/blog/2012/12/19/tutoriel-compressor-4/">Tutoriel Compressor 4</a></li><li style="margin:0"><a href="http://www.tutorom.fr/blog/2012/12/12/apple-quicktime-sous-windows-8/">Apple QuickTime sous Windows 8</a></li>
                    </ul>                <div style="background:#fff; padding:3px 100px 3px 10px; -webkit-border-radius: 10px; -moz-border-radius:10px; border-radius:10px">
                        <h4 style="margin-top:0">Nous suivre :</h4>
                        <a href="http://www.facebook.com/pages/Tutoromfr/143596302341784" style="margin-right:5px">
                            <img alt="sur Facebook" src="http://www.tutorom.fr/themes/default/images/facebook.png"></a>
                        <a href="http://www.youtube.com/user/vtcfr" style="margin-right:5px">
                            <img alt="sur Youtube" src="http://www.tutorom.fr/themes/default/images/youtube.png"></a>
                        <a href="http://www.tutorom.fr/blog/feed/" style="margin-right:5px">
                            <img alt="RSS" src="http://www.tutorom.fr/themes/default/images/rss.png"></a>
                        <a href="https://twitter.com/#!/tutorom" style="margin-right:5px">
                            <img alt="Twitter" src="http://www.tutorom.fr/themes/default/images/twitter.png"></a>
                    </div>
                </div>
            </div>
            <!-- end Bottom -->



            <p class="address">
                LOGIVARO - 177, rue Jean Carrara  83600 Fréjus - Tél. +33 (0)4 94 52 89 26 - Fax. +33 (0)4 94 51 65 72 - <a href="mailto:info@logivaro.fr">info@logivaro.fr</a>
            </p>



            <p class="f_sites"><a target="_blank" href="http://www.logivaro.fr">www.logivaro.fr</a> |
                <a target="_blank" href="http://vod.tutorom.fr">vod.tutorom.fr</a> |
                <a target="_blank" href="http://www.logivaro-elearning.com" class="noborder">www.logivaro-elearning.com</a> 
            </p>
            <p class="legals">&copy; 2013 Logivaro - Tous droits réservés pour tous pays | Tutorom<sup>&reg;</sup> est une marque déposée par Logivaro.</p>

        </div>
    </div>
    <?php
}

add_filter('wp_footer', 'pc_custom_footer');
?>